// CLS_DlgOtherName.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "CLS_DlgOtherName.h"
#include "Include/CLS_NVDSDK_Interface.h"
#include "CommonFun.h"


// CLS_DlgOtherName Ի

IMPLEMENT_DYNAMIC(CLS_DlgOtherName, CDialog)

CLS_DlgOtherName::CLS_DlgOtherName(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CLS_DlgOtherName::IDD, pParent)
	, m_iMaxWin(0)
	, m_iInputChn(0)
{
	memset(&m_tSmoothMode,0x00,sizeof(SmoothMode));
}

CLS_DlgOtherName::~CLS_DlgOtherName()
{
}

void CLS_DlgOtherName::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CBO_CHANNEL_NO, m_cboChannelNo);
	DDX_Control(pDX, IDC_EDT_OTHER_NAME, m_edtOtheerName);
	DDX_Text(pDX, IDC_EDT_MAX_WIN, m_iMaxWin);
	DDV_MinMaxInt(pDX, m_iMaxWin, 0, 10000);
	DDX_Control(pDX, IDC_LIST_LAYOUT, m_lstLayout);
	DDX_Control(pDX, IDC_LIST_RESOLUTION, m_lstResolution);
	DDX_Control(pDX, IDC_CBO_CHANNEL_TYPE, m_cboChannelType);
	DDX_Control(pDX, IDC_COMBO_INPUTCHN, m_cboInputChnNum);
	DDX_Text(pDX, IDC_EDIT_INPUTCHN, m_iInputChn);
	DDX_Control(pDX, IDC_LIST_HDMODE_OUTCHN, m_lstHdModeOutChn);
	DDX_Control(pDX, IDC_COMBO_INPUTCHNSET, m_cboInputChnSet);
}


BEGIN_MESSAGE_MAP(CLS_DlgOtherName, CDialog)
	ON_BN_CLICKED(IDC_BTN_SET, &CLS_DlgOtherName::OnBnClickedBtnSet)
	ON_CBN_SELCHANGE(IDC_CBO_CHANNEL_NO, &CLS_DlgOtherName::OnCbnSelchangeCboChannelNo)
	ON_BN_CLICKED(IDC_BUTTON_SETSMOOTH, &CLS_DlgOtherName::OnBnClickedButtonSetsmooth)
	ON_CBN_SELCHANGE(IDC_COMBO_INPUTCHN, &CLS_DlgOtherName::OnCbnSelchangeComboInputchn)
	ON_CBN_SELCHANGE(IDC_COMBO_INPUTCHNSET, &CLS_DlgOtherName::OnCbnSelchangeComboInputchnset)
END_MESSAGE_MAP()

const char g_Resolution[][32]={
	"VGA_None",
	"VGA_800x600_60",                                  
	"VGA_1024x768_60",                                 
	"VGA_1280x1024_60",                                
	"VGA_1280x720P_60",                                   
	"VGA_1920x1080P_60",                                   
	"VGA_1280x720P_50",                                  
	"VGA_1920x1080P_50",                                   
	"VGA_1920x1080I_60",                                  
	"VGA_1920x1080I_50",
	"VGA_1366x768_60",
	"VGA_1440x900_60",
	"VGA_1280x800_60", 
	"VGA_2560x1600_30",                      
	"VGA_3840x2160_30",
	"VGA_3840x2160_60"   
};

// CLS_DlgOtherName Ϣ

void CLS_DlgOtherName::OnBnClickedBtnSet()
{
	DevCommonName tName;
	CString csName;
	tName.iSize = sizeof(DevCommonName);
	tName.iChannelType = m_cboChannelType.GetCurSel();
	GetDlgItemText(IDC_EDT_OTHER_NAME, csName);
	memcpy(tName.cChannelName,csName,sizeof(char)*64);

	/*int iIndex = m_cboChannelNo.GetCurSel();*/
	int iChannel = GetComboData(&m_cboChannelNo);//m_cboChannelNo.GetItemData(iIndex);

	int iRet = DEC_ClientSetDevConfig(m_iLogonid, iChannel, 
		0, CMD_DEC_CFG_DEVCOMMONNAME, &tName, sizeof(DevCommonName));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgOtherName::UpdateName] Looping!ID(%d),Channel(%d)",m_iLogonid,iChannel);
		return;
	}
}

BOOL CLS_DlgOtherName::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetDlgItemText(IDC_STATIC_LAYOUT, GetTextByLan("沼б","Layout List"));
	SetDlgItemText(IDC_STATIC_RESOLUTION, GetTextByLan("ֱͨб","Resolution List"));

	int iRet = CreateChannelCombo(m_iLogonid, &m_cboChannelNo);
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"CreateChannelCombo");
		return FALSE;
	}

	m_lstLayout.SetExtendedStyle(m_lstLayout.GetExtendedStyle() | 
		LVS_SHOWSELALWAYS |LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);


	m_lstResolution.SetExtendedStyle(m_lstResolution.GetExtendedStyle() | 
		LVS_SHOWSELALWAYS |LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);

	m_lstHdModeOutChn.SetExtendedStyle(m_lstHdModeOutChn.GetExtendedStyle() | 
		LVS_SHOWSELALWAYS |LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);


	InsertColumn(m_lstLayout,0,"NO.",LVCFMT_LEFT,40);
	InsertColumn(m_lstLayout,1,"Number",LVCFMT_LEFT,60);

	InsertColumn(m_lstResolution,0,"NO.",LVCFMT_LEFT,40);
	InsertColumn(m_lstResolution,1,"Resolution",LVCFMT_LEFT,130);

	InsertColumn(m_lstHdModeOutChn,0,"NO.",LVCFMT_LEFT,40);
	InsertColumn(m_lstHdModeOutChn,1,"ͨ",LVCFMT_LEFT,130);

	m_cboChannelType.SetCurSel(0);

	UpdateName();
	UpdateMaxWin();
	UpdateLayout();
	UpdateResolution();
	UpdateHDModeOutChn();


	tDevInfo tInfo = {0};
	iRet = DEC_ClientGetDevConfig(m_iLogonid, 0, 
		0, CMD_DEC_CFG_DEV_INFO, &tInfo, sizeof(tDevInfo));
	if(iRet == ERR_SUCCESS )
	{
		for (int i = 0; i < tInfo.iLocalInChnNum; i++)
		{
			CString tmp;
			tmp.Format("%d",i);
			m_cboInputChnNum.AddString(tmp);
		}
	}

	m_cboInputChnSet.AddString("0:ʹ");
	m_cboInputChnSet.AddString("1:ʹ");

	m_iInputChn = m_tSmoothMode.iLocalInNum = tInfo.iLocalInChnNum;

	UpdateSmooth();
	UpdateData(FALSE);


	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣: OCX ҳӦ FALSE
}

void CLS_DlgOtherName::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* _pData)
{
	if(NULL == _pData)
		return;
	switch(_pData->m_iMsg)
	{
	case DEC_PARACHANGE_CHAN_MAX_WIN:
		{
			UpdateMaxWin();
		}
		break;
	case DEC_PARACHANGE_CHAN_LAYOUTLIST:
		{
			UpdateLayout();
		}
		break;
	case DEC_PARACHANGE_CHAN_RESOLUTIONLIST:
		{
			UpdateResolution();
		}
		break;
	case DEC_PARACHANGE_SMOOTH_MODE:
		{
			UpdateSmooth();
		}
		break;
	case DEC_PARACHANGE_HDMODE_OUTCHN:
		{
			UpdateHDModeOutChn();
		}
		break;
	default:
		break;
	}
}

void CLS_DlgOtherName::UpdateName()
{
	DevCommonName tOtherName = {0};
	tOtherName.iSize = sizeof(DevCommonName);
	int iIndex = m_cboChannelNo.GetCurSel();
	int iChannel = m_cboChannelNo.GetItemData(iIndex);
	tOtherName.iChannelType = m_cboChannelType.GetCurSel();
	CString tTempName;
	int iRet = DEC_ClientGetDevConfig(m_iLogonid, iChannel, 0, CMD_DEC_CFG_DEVCOMMONNAME, &tOtherName, sizeof(DevCommonName));
	if(iRet == -1)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgOtherName::UpdateName] Looping!ID(%d),Channel(%d)",m_iLogonid,iChannel);
		return;
	}
	tTempName.Format(_T("%s"),tOtherName.cChannelName);
	SetDlgItemText(IDC_EDT_OTHER_NAME, tTempName);
}

void CLS_DlgOtherName::Initialize(TDECPARAM* _pdecParam)
{
	/*bool blUsedChannel[DEC_MAX_CHANNEL_NUM_NEW ] = {false};
	bool blUsedScreen[DEC_MAX_VIRTUAL_CHANNEL_NUM] = {false};
	int iIndexChannel = 0;
	int iIndexSysChannel = 0;
	CreateVVOInfo strCreateVVOInfo = {0};
	strCreateVVOInfo.iBufSize = sizeof(CreateVVOInfo);
	int iRet = -1;
	for (int i=0; i<DEC_MAX_VIRTUAL_CHANNEL_NUM; i++)
	{
		BaseOffset tGetStartAddress;
		iRet = DEC_ClientGetDevConfig(m_iLogonid, 0, 0, CMD_DEC_CFG_BASE_OFFSET, 
			&tGetStartAddress, sizeof(BaseOffset));
		if(iRet < 0)
		{
			AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonid);
			continue;
		}
		strCreateVVOInfo.iVVOChannelNo = i + tGetStartAddress.iSplitScreen;
		iRet = DEC_ClientGetDevConfig(m_iLogonid, 0, 0, CMD_DEC_CFG_CREATE_VVO, &strCreateVVOInfo, sizeof(CreateVVOInfo));
		if(iRet < 0)
		{
			AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_CREATE_VVO] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonid);
			continue;
		}

		int iUsedNum = strCreateVVOInfo.iCols * strCreateVVOInfo.iRows;

		if (iUsedNum > 0)
		{
			blUsedScreen[i] = true;
		}

		for (int j=0; j<iUsedNum; j++)
		{
			if (0 <= strCreateVVOInfo.iInputChannel[j] && strCreateVVOInfo.iInputChannel[j] < DEC_MAX_CHANNEL_NUM_NEW)
			{
				blUsedChannel[strCreateVVOInfo.iInputChannel[j]] = true;
			}
		}
	}*/	
}

void CLS_DlgOtherName::OnCbnSelchangeCboChannelNo()
{
	UpdateName();
	UpdateMaxWin();
	UpdateLayout();
	UpdateResolution();
}

void CLS_DlgOtherName::UpdateMaxWin()
{
	DecChanMaxWin tDecChanMaxWin = {0};

	int iChannel = GetComboData(&m_cboChannelNo);
	int iRet = DEC_ClientGetDevConfig(m_iLogonid, iChannel, 0, CMD_DEC_CFG_CHANNEL_MAX_WIN, &tDecChanMaxWin, sizeof(DecChanMaxWin));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgOtherName::UpdateMaxWin] error!ID(%d),Channel(%d)",m_iLogonid,iChannel);
		return;
	}
	m_iMaxWin = tDecChanMaxWin.iMaxWin;
	UpdateData(FALSE);
}

void CLS_DlgOtherName::UpdateLayout()
{
	DecChanLayoutList tLayout = {0};

	int iChannel = GetComboData(&m_cboChannelNo);
	int iRet = DEC_ClientGetDevConfig(m_iLogonid, iChannel, 0, CMD_DEC_CFG_CHANNEL_LAYOUTLIST, &tLayout, sizeof(DecChanLayoutList));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgOtherName::UpdateLayout] error!ID(%d),Channel(%d)",m_iLogonid,iChannel);
		return;
	}
	m_lstLayout.DeleteAllItems();
	for (int i = 0; i < tLayout.iLayoutNum; i++)
	{
		CString csPicNum;
		csPicNum.Format("%d",tLayout.iLayout[i]);
		CString csNo;
		csNo.Format("%d",i);
		m_lstLayout.InsertItem(i,csNo);
		m_lstLayout.SetItemText(i,1,csPicNum);
	}
}
void CLS_DlgOtherName::UpdateResolution()
{
	DecChanResolutionList tLayout = {0};

	int iChannel = GetComboData(&m_cboChannelNo);
	int iRet = DEC_ClientGetDevConfig(m_iLogonid, iChannel, 0, CMD_DEC_CFG_CHANNEL_RESOLUTIONLIST, &tLayout, sizeof(DecChanResolutionList));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgOtherName::UpdateLayout] error!ID(%d),Channel(%d)",m_iLogonid,iChannel);
		return;
	}
	m_lstResolution.DeleteAllItems();
	for (int i = 0; i < tLayout.iResolutionNum; i++)
	{
		CString csResoluition;
		if(tLayout.iResolution[i]>=0 && tLayout.iResolution[i]<16)
		{
			csResoluition.Format("%s",g_Resolution[tLayout.iResolution[i]]);
		}else{
			csResoluition.Format("%d",tLayout.iResolution[i]);
		}
		CString csNo;
		csNo.Format("%d",i);
		m_lstResolution.InsertItem(i,csNo);
		m_lstResolution.SetItemText(i,1,csResoluition);
	}
}

void CLS_DlgOtherName::UpdateSmooth()
{
	int iRet = DEC_ClientGetDevConfig(m_iLogonid, 0, 
		0, CMD_DEC_CFG_SMOOTH_MODE, &m_tSmoothMode, sizeof(SmoothMode));
    if(iRet == ERR_SUCCESS)
	{
		m_cboInputChnNum.SetCurSel(0);
		OnCbnSelchangeComboInputchn();
		((CButton *)GetDlgItem(IDC_CHECK_SMOOTH))->SetCheck(m_tSmoothMode.iEnable);
	}else{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgOtherName::UpdateSmooth] error!ID(%d)",m_iLogonid);
	}

}

void CLS_DlgOtherName::UpdateHDModeOutChn()
{
	HDModeOutChannel tHDMode = {0};
	int iRet = DEC_ClientGetDevConfig(m_iLogonid, 0, 
		0, CMD_DEC_CFG_HDMODE_OUTCHANNEL, &tHDMode, sizeof(HDModeOutChannel));
	if(iRet == ERR_SUCCESS)
	{
		m_lstHdModeOutChn.DeleteAllItems();
		for (int i = 0; i < tHDMode.iOutChnNum; i++)
		{
			CString csPicNum;
			csPicNum.Format("%d",tHDMode.iOutChnn[i]);
			CString csNo;
			csNo.Format("%d",i);
			m_lstHdModeOutChn.InsertItem(i,csNo);
			m_lstHdModeOutChn.SetItemText(i,1,csPicNum);
		}
	}else{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgOtherName::UpdateHDModeOutChn] error!ID(%d)",m_iLogonid);
	}

}

void CLS_DlgOtherName::OnBnClickedButtonSetsmooth()
{
	// TODO: Add your control notification handler code here
	m_tSmoothMode.iEnable = ((CButton *)GetDlgItem(IDC_CHECK_SMOOTH))->GetCheck();
	int iRet = DEC_ClientSetDevConfig(m_iLogonid, 0, 
		0, CMD_DEC_CFG_SMOOTH_MODE, &m_tSmoothMode, sizeof(SmoothMode));
	if(iRet != ERR_SUCCESS)
	{
		AfxMessageBox("SmoothModeʧ");
	}

}

void CLS_DlgOtherName::OnCbnSelchangeComboInputchn()
{
	// TODO: Add your control notification handler code here
	int iIndex = m_cboInputChnNum.GetCurSel();
	if(iIndex < DEC_MAX_ENCODE_CHANNEL_NUM)
	{
		m_cboInputChnSet.SetCurSel(m_tSmoothMode.iEnableChnn[iIndex]);
	}

}

void CLS_DlgOtherName::OnCbnSelchangeComboInputchnset()
{
	// TODO: Add your control notification handler code here
	int iIndex = m_cboInputChnNum.GetCurSel();
	if(iIndex < DEC_MAX_ENCODE_CHANNEL_NUM)
	{
		m_tSmoothMode.iEnableChnn[iIndex] = m_cboInputChnSet.GetCurSel();

	}
}
